INSERT INTO `school_flag` (`name_scf`, `alias_scf`, `type_scf`, `description_scf`, `status_scf`) VALUES ('USE_NEW_HOME_TEACHER', 'Otros', 'SETUP', 'Permite usar la nueva versión del home teacher, esta versión oculta las opciones del home teacher para mostrar en una sola pantalla las opciones que se pueden agrupar', 'INACTIVE');


-- creo tabla catalogo de banderas
CREATE TABLE IF NOT EXISTS flag_dropdown_bar (
  serial_fdb        int          NOT NULL AUTO_INCREMENT,
  name_dfb          varchar(50)  NOT NULL,
  description_dfb   varchar(250) NOT NULL,
  status_dfb        enum('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (serial_fdb)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- creo tabla para controlar las banderas del navbar principal
CREATE TABLE IF NOT EXISTS flag_dropdown_process (
  serial_fdp        int          NOT NULL AUTO_INCREMENT,
  serial_prc        int          NOT NULL,
  serial_fdb        int          NOT NULL,
  status_fdp        enum('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (serial_fdp),
  FOREIGN KEY (serial_prc) REFERENCES process(serial_prc),
  FOREIGN KEY (serial_fdb) REFERENCES flag_dropdown_bar(serial_fdb)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SCHOOL_YEAR', 'Dropdown con los años lectivos', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SECTION', 'Dropdown con las secciones a nivel general', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SECTION_TEACHER', 'Dropdown con las secciones a nivel de docente', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SECTION_SUPERVISOR', 'Dropdown con las secciones a nivel de inspector', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SECTION_COURSE_DIRECTOR', 'Dropdown con las secciones a nivel de dirigente', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('COURSE', 'Dropdown con los cursos a nivel general', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('COURSES_TEACHER', 'Dropdown con los cursos a nivel de docente', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('COURSES_SUPERVISOR', 'Dropdown con los cursos a nivel de supervisor', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`) VALUES ('COURSES_COURSE_DIRECTOR', 'Dropdown con los cursos a nivel de dirigente');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('LEVEL', 'Dropdown con los niveles a nivel general', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('LEVEL_TEACHER', 'Dropdown con los niveles a nivel de docente', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('LEVEL_SUPERVISOR', 'Dropdown con los niveles a nivel de inspector', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SUBJECTS', 'Dropdown con los niveles a nivel general', 'ACTIVE');
INSERT INTO `flag_dropdown_bar` (`name_dfb`, `description_dfb`, `status_dfb`) VALUES ('SUBJECTS_TEACHER', 'Dropdown con los niveles a nivel de docente', 'ACTIVE');


-- procesos
INSERT INTO  `process` (`name_prc`, `link_prc`, `weight_prc`, `status_prc`, `system_version_prc`) VALUES ('Home Teacher Nueva versión', 'laravel/public//home-teacher/index', '1.00', 'LOCKABLE', 'NEW');
INSERT INTO `process` (`name_prc`, `link_prc`, `weight_prc`, `status_prc`, `system_version_prc`) VALUES ('Académico como profesor nueva versión', 'laravel/public/teacher-grade-entry/index', '1.00', 'LOCKABLE', 'NEW');

INSERT INTO `flag_dropdown_process` (`serial_fdp`, `serial_prc`, `serial_fdb`, `status_fdp`) VALUES (NULL, '879', '1', 'ACTIVE');
INSERT INTO `flag_dropdown_process` (`serial_fdp`, `serial_prc`, `serial_fdb`, `status_fdp`) VALUES (NULL, '878', '1', 'ACTIVE');

INSERT INTO process (`serial_prc`, `prc_serial_prc`, `name_prc`, `link_prc`, `weight_prc`, `status_prc`, `system_version_prc`) VALUES (NULL, '199', 'Estadisticas', 'teacher-statistic/index', '1.00', 'LOCKABLE', 'NEW');