<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\Teacher\HomeTeacherController;
use App\Http\Controllers\Teacher\TeacherGradeEntryController;
use App\Http\Controllers\Teacher\StatisticTeacherController;
use App\Http\Controllers\CalendarUserController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

/*
Route::get('/', function () {
    return view('welcome');
});
*/

Route::get('/auth_user', function () {
    //return view('menu.menu');
})->middleware('initial.token');

Route::get('/', function (\Illuminate\Http\Request $request) {
    return view('test.test');
})->name('/');//->middleware('initial.token');

Route::controller(MenuController::class)->group(function(){
    Route::get('/menu','getMenu')->name('/menu')->middleware('initial.token');
});

/**
 * TEACHER OPTIONS
 *
 *
 */
//Teacher grades
Route::controller(HomeTeacherController::class)->group(function(){
    Route::get('/home-teacher/index','getIndex')->name('/home-teacher/index')->middleware('initial.token');
    Route::post('/schedule-teacher','postScheduleTeacher')->name('/schedule-teacher')/*->middleware('initial.token')*/;
});
Route::controller(TeacherGradeEntryController::class)->group(function(){
    Route::get('/teacher-grade-entry/index','getIndex')->name('/teacher-grade-entry/index')/*->middleware('initial.token')*/;
    Route::post('/teacher-grade-entry/contentNav','postContentNav')->name('/contentNav')/*->middleware('initial.token')*/;
});
//Teacher statistics
Route::controller(StatisticTeacherController::class)->group(function(){
    Route::get('/teacher-statistic/index','getIndex')->name('/teacher-statistic/index');//->middleware('initial.token');
    Route::post('/teacher-statistic/contentNav','postContentNav')->name('/teacher-statistic/contentNav')/*->middleware('initial.token')*/;
});

//calendario
Route::controller(CalendarUserController::class)->group(function(){
    Route::get('/calendar-user','getIndex')->name('/calendar-user')/*->middleware('initial.token')*/;
});

    /*->middleware('initial.token')*/;

/**
 * Rutas llamadas solo con ajax
 *
 */
Route::post('/update-serial_scy_principal',function (){
    if(isset($_POST['serial_scy_principal']) && $_POST['serial_scy_principal']>0){
        $_SESSION['school_year_use']=$_POST['serial_scy_principal'];
        //se debe setear los dropdown que preceden al school_year a cero
        $_SESSION['section_use']=0;

        return json_encode(array('status'=>200,'response'=>'Success'));
    }else{
        return json_encode(array('status'=>401,'response'=>'No autorizado'));
    }
})->name('/update-serial_scy_principal')/*->middleware('initial.token')*/;



Route::get('404-page', function () {
    return view('menu.menu');
})->middleware('initial.token');
