<?php

namespace App\Service\Security;

use App\Contracts\Security\LifeTokenInterface;
use App\Contracts\Security\TokenRandomGenerateInterface;
use Illuminate\Support\Facades\Config;

class TokenRandomGenerateService implements TokenRandomGenerateInterface
{
    public function __construct(LifeTokenInterface $lifeToken)
    {
        $this->lifeToken = $lifeToken;
    }

    public function generateToken($typeToken, array $data)
    {
        $token = "NO_TOKEN_GENERATE";
        switch ($typeToken) {
            case 'life_token':
                if (isset($data['serial_usr'])) {
                    $token = $this->lifeToken->generateToken($data['serial_usr']);
                }
                break;
        }
        return $token;
    }
}
