<?php

namespace App\Service;

use Illuminate\Support\Facades\Config;
use App\Contracts\MenuServiceInterface;
use App\Contracts\SubMenuProfileInterface;
use App\Repository\ProcessRepository;
use App\Contracts\SchoolSetup\SchoolSetupInterface;


class MenuService implements MenuServiceInterface
{
    public function __construct(
        MenuServiceInterface $menu,
        SubMenuProfileInterface $submenu,
        ProcessRepository $processRepository,
        SchoolSetupInterface $schoolSetupInterface
    )
    {
        $this->menu = $menu;
        $this->submenu = $submenu;
        $this->processRepository = $processRepository;
        $this->schoolSetupInterface = $schoolSetupInterface;
        $this->documentRootLogic=Config::get("constants.document_root_logic_sst");
        $this->documentRootSst=Config::get("constants.document_root_logic_sst");
        $this->principalDomain=Config::get("constants.principal_domain");
        $this->secundaryDomain=Config::get("constants.secundary_domain");
    }

    public function menu()
    {
        $serialPrf=session('current_serial_prf');
        $menu = $this->processRepository->menuOld($serialPrf);
        $out = '<div class="col-md-2 menuIzq d-md-inline d-lg-inline d-xl-inline">
                        <div class="logo"></div>
                        <div class="div-opciones-menu">
                            <ul class="opcionesM">';
        for ($i = 0; $i < count($menu); $i++) {
            //if (is_array($menu [$i])) {
            if ($menu [$i]->prc_serial_prc == 0) {
                $out .= '<li show_menu="no_show" class="border-botton">' .
                    '<a class="cat-menu" style="font-size: 13px !important;">';
                $out .= ($menu[$i]->name_prc);
                $out .= '</a>';
                $child = $this->menuItem($menu, $menu[$i]->serial_prc, $menu[$i]->name_prc,$menu[$i]->serial_prc);
                if ($child != FALSE) {
                    $out .= $child;
                }
                $out .= '</li>';
            }
            //}
        }
        $out .= '</ul>' . "\n";
        $out .= '    </div>
                </div>';
        $menu = $out . "\n\t";
        return $menu;

/*
        $menuArray = array();
        $mainMenu = $this->menu->menu();
        foreach ($mainMenu as $item) {
            $arrayAux = array();
            $submenu = $this->submenu->submenu(1, $item->serial_prc);
            if ($submenu !== false && count($submenu) > 0) {
                $arrayAux['type_prc'] = 'PRINCIPAL';
                $arrayAux['link'] = "#";
                $arrayAux['serial_prc'] = $item->serial_prc;
                $arrayAux['name_prc'] = $item->name_prc;
                $arrayAux['submenu'] = $submenu;
                array_push($menuArray, $arrayAux);
            }
        }
*/
    }

    function menuItem($menu, $item, $cat_name,$principal_menu)
    {
        $has_subcats = FALSE;
        $out = '';
        $out .= '<div style="display: none;">';
        $out .= '<ul class="opcionesM border-left">';
        for ($i = 0; $i < count($menu); $i++) {
            if ($menu [$i]->prc_serial_prc == $item) {
                $has_subcats = TRUE;
                $out .= '<li>';
                if ($menu [$i]->link_prc != "#") {
                    if(isset($menu [$i]->system_version_prc) && $menu [$i]->system_version_prc=='CURRENT'){
                        $out .= '<div class="resaltar"> <a href="' . $this->principalDomain.'/'.$this->documentRootLogic . $menu [$i]->link_prc . '" ';
                    }else{
                        $out .= '<div class="resaltar"> <a href="' . $this->secundaryDomain.'/' . $menu [$i]->link_prc . '" ';
                    }
                    $out .= ' serial="' . $menu [$i]->serial_prc . '" ';
                }
                $child = $this->menuItem($menu, $menu[$i]->serial_prc, $menu[$i]->name_prc,$principal_menu);
                if (!$child) {
                    /*if($_SESSION['menu_prc']>0 && $_SESSION['menu_prc'] == $menu [$i]['serial_prc']){
                        $out .= 'style="color: black !important;" class="item-menu current-menu item-selected" serial_parent="'.$principal_menu.'">&nbsp;&nbsp;&nbsp;' ;
                    }else{
                        $out .= 'style="color: black !important;" class="item-menu" serial_parent="'.$principal_menu.'">';
                    }*/
                    $out .= 'style="color: black !important;" class="item-menu" serial_parent="'.$principal_menu.'">';
                } else {
                    $out .= '>';
                }
                //$out .= utf8_encode($menu [$i] ->name_prc) . '</a>';
                $out .= $menu [$i]->name_prc . '</a>';
                $out .= $child;
                $out .= '</li>';
            }
        }
        $out .= '</ul>';
        $out .= '</div>';
        return ($has_subcats) ? ($out) : FALSE;
    }

}
