<?php

namespace App\Service\Flag;
use App\Contracts\Repository\Flag\FlagDropdownProcessInterface;
use App\Contracts\Service\Flag\FlagDropdownProcessServiceInterface;

class FlagDropdownConfiguredService implements FlagDropdownProcessServiceInterface
{
    protected $subjectsEmployeeInterface;

    /**
     * FlagDropdownConfiguredService constructor.
     * @param FlagDropdownProcessInterface $flagDropdownProcess --> app/Repository/Flag/FlagToProcessRepository.php
     */
    public function __construct(FlagDropdownProcessInterface $flagDropdownProcess)
    {
        $this->flagDropdownProcess = $flagDropdownProcess;
    }

    public function flagsDropdownProcess($namePrc,$nameFlag)
    {
        switch ($nameFlag) {
            case "ALL":
                return $this->flagDropdownProcess->flagsDropdownProcess($namePrc, $nameFlag);
                break;
            case "ONLY_TEACHER":
                return $this->flagDropdownProcess->flagsDropdownProcess($namePrc, 'TEACHER');
                break;
            case "ONLY_SUPERVISOR":
                return $this->flagDropdownProcess->flagsDropdownProcess($namePrc, 'SUPERVISOR');
                break;
                //retorna una coleccion
            default:
                return $this->flagDropdownProcess->flagsDropdownProcess($namePrc, $nameFlag);
                break;
        }

    }
}
