<?php

namespace App\Service\Flag;

use App\Contracts\Repository\FlagSetupInterface;
use App\Contracts\Repository\FlagYearInterface;
use App\Contracts\Service\Flag\FlagConfiguredInterface;


class FlagConfiguredService implements FlagConfiguredInterface
{
    protected $subjectsEmployeeInterface;

    /**
     * FlagConfiguredService constructor.
     * @param FlagSetupInterface $flagSetupInterface --> app/Repository/FlagSetupRepository.php
     * @param FlagYearInterface $flagYearInterface   --> app/Repository/FlagYearRepository.php
     */
    public function __construct(FlagSetupInterface $flagSetupInterface, FlagYearInterface $flagYearInterface)
    {
        $this->flagSetupInterface = $flagSetupInterface;
        $this->flagYearInterface = $flagYearInterface;
    }

    public function flagConfigured($typeScf, $nameScf, $serialScy)
    {
        switch ($nameScf) {
            case "SETUP":
                return $this->flagSetupInterface->flagSetup($typeScf, $nameScf);
                break;
            case "YEAR":
                return $this->flagYearInterface->flagYear($typeScf, $nameScf,$serialScy);
                break;
            default:
                return $this->flagSetupInterface->flagSetup($typeScf, $nameScf);
                break;
        }

    }
}
