<?php

namespace App\Service\Average;


use App\Contracts\Repository\StudentSubperiodAverageSubjectCourseInterface;
use App\Contracts\Repository\SubperiodAverageOptionalSubjectInterface;
use App\Contracts\Repository\SubperiodAverageSubjectInterface;
use App\Contracts\Service\Average\SubperiodAverageServiceInterface;

class SubperiodAverageService implements SubperiodAverageServiceInterface
{
    public function __construct(
        StudentSubperiodAverageSubjectCourseInterface $studentSubperiodAverageSubjectCourseInterface,
        SubperiodAverageSubjectInterface $subperiodAverageSubject,
        SubperiodAverageOptionalSubjectInterface $subperiodAverageOptionalSubject
    )
    {
        $this->studentSubperiodAverageSubjectCourse=$studentSubperiodAverageSubjectCourseInterface;
        $this->subperiodAverageSubject=$subperiodAverageSubject;
        $this->subperiodAverageOptionalSubject=$subperiodAverageOptionalSubject;
    }

    /**
     * @author Diego Navarrete
     * @date 2023-11-23
     * @serviceProvider
     * @param $serialSbp subperiodo
     * @param $serialSbcOsb serial_sbc o serial_osb
     * @param $activeRetired si se toma en cuenta el status del estudiante si es RETIRADO o REGISTRADO 'ACTIVE','RETIRED'
     * @param $typeSubject si es obligatoria, optativa o ambas 'MANDATORY','OPTATIVE','ALL'
     * @param $serialLop solo si es necesario, caso contrario false
     * @param $typeAvg casos para el switch 'MANDATORY_ALL_STUDENTS', aumentar segun se añadan casos
     * @description metodo que regresa el promedio por subperiodo de materias obligatorias
     * @param StudentSubperiodAverageSubjectCourseInterface $studentSubperiodAverageSubjectCourseInterface -> app/Repository/StudentSubperiodAverageSubjectCourseRepository.php
     * @param SubperiodAverageSubjectInterface $subperiodAverageSubject -> app/Repository/SubperiodAverageSubjectRepository.php
     * @param SubperiodAverageOptionalSubjectInterface $subperiodAverageOptionalSubject -> app/Repository/SubperiodAverageOptionalSubjectRepository.php
     */
    public function getAverage($serialSbp,$serialSbcOsb,$activeRetired,$serialStd,$typeSubject,$serialLop,$typeAvg)
    {

        switch ($typeAvg){
            case 'MANDATORY_ALL_STUDENTS':
                return $this->studentSubperiodAverageSubjectCourse->getAverageSubperiodSubjectCourseStudent($serialSbp,$serialSbcOsb,$serialStd,$activeRetired);
                break;

            case 'MANDATORY_BY_SUBJECT':
                return $this->subperiodAverageSubject->getSubperiodAverageSubject($serialSbp,$serialSbcOsb,$activeRetired);
                break;

            case 'OPTATIVE_BY_SUBJECT':

                return $this->subperiodAverageOptionalSubject->getSubperiodAverageOptionalSubject($serialSbp,$serialSbcOsb,$activeRetired);
                break;

            default:
                return false;
                break;
        }


    }
}
