<?php


namespace App\Repository;


use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\User;

class UserRepository implements ReadOnlyInterface
{

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function getOne($serial)
    {
        return $this->user->find($serial);
    }

    public function getAll()
    {
        return $this->user->all();
    }

    public function getAllActive()
    {
        return $this->user->where('status_usr', '=', 'LOCKABLE')->get();
    }

    public function getCurrentUser($serial)
    {
        $result = $this->join('profile_process as ppr', 'ppr.serial_prc', '=', 'process.serial_prc')
            ->join('profile as prf', 'prf.serial_prf', '=', 'ppr.serial_prf')
            ->where('')
            ->get();
    }
    public function getActiveByName($name)
    {
        return $this->user->where('username_usr', '=', $name)->where('status_usr', '=', 'LOCKABLE')->get();
    }
}
