<?php


namespace App\Repository;
use App\Contracts\Repository\SubperiodAverageSubjectInterface;
use App\Models\StudentSubjectSubperiodAverage;
use Illuminate\Support\Facades\DB;

class SubperiodAverageSubjectRepository implements SubperiodAverageSubjectInterface
{
    public function __construct(StudentSubjectSubperiodAverage $studentSubjectSubperiodAverage)
    {
        $this->studentSubjectSubperiodAverage = $studentSubjectSubperiodAverage;
    }

    /**
     * @author Diego Navarrete
     * @date 2023-11-26
     * @serviceProvider
     * @param $serialSbp subperiodo
     * @param $serialSbc serial_sbc
     * @param $activeRetired si se toma en cuenta el status del estudiante si es RETIRADO o REGISTRADO 'ACTIVE','RETIRED'
     * @description metodo que regresa el promedio por subperiodo por materia
     */

    public function  getSubperiodAverageSubject($serialSbp,$serialSbc,$activeRetired)
    {
        $result=$this->studentSubjectSubperiodAverage
                     ->join('student_by_course as stc',function ($join) use($serialSbc){
                         $join->on('stc.serial_std','=','student_subject_subperiod_average.serial_std')
                         ->where('student_subject_subperiod_average.serial_sbc','=',$serialSbc);
                     })->join('course as crs',function ($join) use($serialSbc){
                         $join->on('crs.serial_crs','=','stc.serial_crs')
                              ->on('student_subject_subperiod_average.serial_scy','=','crs.serial_scy');
                     });
        if($activeRetired='ACTIVE'){
            $result=$result->where('status_stc','=','ACTIVE');
        }elseif($activeRetired='RETIRED'){
            $result=$result->where('status_stc','=','RETIRED');
        }
        $result=$result->join('student_year as sty',function ($join){
            $join->on('sty.serial_std','=','stc.serial_std')
                 ->on('sty.serial_scy','=','student_subject_subperiod_average.serial_scy')
                 ->whereRaw('(sty.comment_sty is null or sty.comment_sty  !="**LEVEL CHANGE**")');
        });
        if($activeRetired='ACTIVE'){
            $result=$result->where('status_sty','=','REGISTERED');
        }
        $result=$result->where('serial_sbp','=',$serialSbp)
                       ->selectRaw('avg(average_sss) as subject_average')
                       ->first();
        return $result;


    }

}
