<?php


namespace App\Repository;
use App\Contracts\Repository\SubperiodAverageOptionalSubjectInterface;
use App\Models\StudentSubjectSubperiodAverage;
use Illuminate\Support\Facades\DB;

class SubperiodAverageOptionalSubjectRepository implements SubperiodAverageOptionalSubjectInterface
{
    public function __construct(StudentSubjectSubperiodAverage $studentSubjectSubperiodAverage)
    {
        $this->studentSubjectSubperiodAverage = $studentSubjectSubperiodAverage;
    }

    /**
     * @author Diego Navarrete
     * @date 2023-11-26
     * @serviceProvider
     * @param $serialSbp subperiodo
     * @param $serialSbc serial_sbc
     * @param $activeRetired si se toma en cuenta el status del estudiante si es RETIRADO o REGISTRADO 'ACTIVE','RETIRED'
     * @description metodo que regresa el promedio por subperiodo por materia optativa
     */

    public function  getSubperiodAverageOptionalSubject($serialSbp,$serialOsb,$activeRetired)
    {


        $result=$this->studentSubjectSubperiodAverage
                     ->join('student_year as sty',function ($join){
                        $join->on('sty.serial_std','=','student_subject_subperiod_average.serial_std')
                             ->on('sty.serial_scy','=','student_subject_subperiod_average.serial_scy')
                             ->whereRaw('(sty.comment_sty is null or sty.comment_sty  !="**LEVEL CHANGE**")');
                     });
        if($activeRetired='ACTIVE'){
            $result=$result->where('status_sty','=','REGISTERED');
        }
        $result=$result->join('student_by_course as stc',function ($join) {
                            $join->on('stc.serial_std','=','sty.serial_std');
                       })->join('course as crs',function ($join){
                            $join->on('crs.serial_crs','=','stc.serial_crs')
                                 ->on('crs.serial_scy','=','sty.serial_scy');
                        });
        if($activeRetired='ACTIVE'){
            $result=$result->where('status_stc','=','ACTIVE');
        }elseif($activeRetired='RETIRED'){
            $result=$result->where('status_stc','=','RETIRED');
        }
        $result=$result->join('student_optional_subject as sos',function ($join) use($serialOsb){
            $join->on('sos.serial_std','=','sty.serial_std')
                 ->on('student_subject_subperiod_average.serial_lop','=','sos.serial_lop')
                 ->where('sos.status_sos','=','ACTIVE')
                 ->where('sos.serial_osb','=',$serialOsb);
        })->join('period as prd',function ($join) {
            $join->on('prd.serial_prd','=','sos.serial_prd')
                 ->where('prd.status_prd','=','ACTIVE');
        })->join('subperiod as sbp',function ($join) use($serialSbp){
            $join->on('sbp.serial_prd','=','prd.serial_prd')
                 ->where('sbp.status_sbp','=','ACTIVE')
                 ->where('sbp.serial_sbp','=',$serialSbp);
        });
            $result=$result->where('student_subject_subperiod_average.serial_sbp','=',$serialSbp)
                       ->selectRaw('avg(average_sss) as subject_average')
                ->first();
        return $result;


    }

}
