<?php


namespace App\Repository;

use Illuminate\Support\Facades\DB;
use App\Contracts\Repository\SubjectsScheduleByTeacherDayInterface;

class SubjectsScheduleByTeacherDayRepository implements SubjectsScheduleByTeacherDayInterface
{
    public function getSubjectsScheduleDay($serialEmp, $serialScy, $day)
    {
        $result = DB::table('cat_subject')
            ->join('subject', 'subject.serial_csb', '=', 'cat_subject.serial_csb')
            ->join('subject_course', function ($join) use($serialEmp){
                $join->on('subject_course.serial_sbj', '=', 'subject.serial_sbj')
                    ->where('subject_course.serial_emp', '=', $serialEmp)
                    ->where('subject_course.status_sbc', '=', 'ACTIVE')
                    ->where('subject.status_sbj', '=', 'ACTIVE')
                    ->where('cat_subject.status_csb', '=', 'ACTIVE');
            })
            ->join('course', function ($join) use($serialScy){
                $join->on('course.serial_crs', '=', 'subject_course.serial_crs')
                    ->where('course.serial_scy', '=', $serialScy);
            })
            ->join('level', 'level.serial_lvl', '=', 'course.serial_lvl')
            ->join('class_group', 'class_group.serial_clg', '=', 'course.serial_clg')
            ->join('schedule', function ($join) use($day){
                $join->on('schedule.serial_sbc', '=', 'subject_course.serial_sbc')
                    ->where('schedule.day_scd', '=', $day)
                    ->where('schedule.status_scd', '=', 'ACTIVE')
                    ->whereRaw('schedule.serial_emp = subject_course.serial_emp');
            })
            ->join('schedule_header', function ($join) {
                $join->on('schedule_header.serial_shd', '=', 'schedule.serial_shd')
                    ->where('schedule_header.status_shd', '=', 'ACTIVE')
                    ->where('schedule_header.in_use_shd', '=', 1);
            })
            ->join('credits_detail', 'credits_detail.serial_cdt', '=', 'schedule.serial_cdt')
            ->select(
                'cat_subject.name_csb',
                'subject_course.serial_sbc as serial_subject',
                'course.serial_crs as course_or_level',
                DB::raw("concat(level.name_lvl,' ',class_group.name_clg) as name_course"),
                DB::raw("'MANDATORY' AS type_subject"),
                'level.name_lvl',
                'credits_detail.start_at_cdt',
                'credits_detail.end_at_cdt',
                'schedule_header.date_start_shd',
                'schedule_header.date_end_shd',
                DB::raw("(select count(distinct(stc.serial_std))
			                        from student_by_course stc 
			                        join student_year sty on sty.serial_std=stc.serial_std
					                        AND stc.status_stc='ACTIVE'
					                        AND sty.status_sty !='RETIRED'
					                        AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')                                            
                                    join student std on std.serial_std=sty.serial_std
					                        AND std.gender_std='MALE'
					                        WHERE stc.serial_crs=course.serial_crs) as total_students_male"),
                DB::raw("(select count(distinct(stc.serial_std))
			                        from student_by_course stc 
			                        join student_year sty on sty.serial_std=stc.serial_std
					                        AND stc.status_stc='ACTIVE'
					                        AND sty.status_sty !='RETIRED'
					                        AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')                                            
                                    join student std on std.serial_std=sty.serial_std
					                        AND std.gender_std='FEMALE'
					                WHERE stc.serial_crs=course.serial_crs) as total_students_female")
            )
            ->union(
                DB::table('cat_subject')
                    ->join('optional_subject', 'optional_subject.serial_csb', '=', 'cat_subject.serial_csb')
                    ->join('optional_subject_level as osl', function ($join) use($serialScy,$serialEmp){
                        $join->on('osl.serial_osb', '=', 'optional_subject.serial_osb')
                            ->where('optional_subject.status_osb', '=', 'ACTIVE')
                            ->where('cat_subject.status_csb', '=', 'ACTIVE')
                            ->where('osl.status_osl', '=', 'ACTIVE')
                            ->where('osl.serial_scy','=',$serialScy)
                            ->where('optional_subject.serial_emp', '=', $serialEmp);
                    })
                    ->join('group_optional_subject', function ($join) {
                        $join->on('group_optional_subject.serial_osb', '=', 'optional_subject.serial_osb')
                            ->where('group_optional_subject.status_gos', '=', 'ACTIVE');
                    })
                    ->join('level_optional_group', function ($join) {
                        $join->on('level_optional_group.serial_lop', '=', 'group_optional_subject.serial_lop')
                            ->where('level_optional_group.status_lop', '=', 'ACTIVE');
                    })
                    ->join('level', 'level.serial_lvl', '=', 'osl.serial_lvl')
                    ->join('schedule', function ($join) use($day){
                        $join->on('schedule.serial_lop', '=', 'level_optional_group.serial_lop')
                            ->where('schedule.day_scd', '=', $day)
                            ->where('schedule.status_scd', '=', 'ACTIVE');
                    })
                    ->join('schedule_header', function ($join) {
                        $join->on('schedule_header.serial_shd', '=', 'schedule.serial_shd')
                            ->where('schedule_header.status_shd', '=', 'ACTIVE')
                            ->where('schedule_header.in_use_shd', '=', 1)
                            ->whereRaw('schedule.serial_emp = optional_subject.serial_emp');
                    })
                    ->join('credits_detail', 'credits_detail.serial_cdt', '=', 'schedule.serial_cdt')
                    ->select(
                        'cat_subject.name_csb',
                        'optional_subject.serial_osb as serial_subject',
                        'osl.serial_lvl as course_or_level',
                        'level.name_lvl as name_course',
                        DB::raw("'MANDATORY' AS type_subject"),
                        'level.name_lvl',
                        'credits_detail.start_at_cdt',
                        'credits_detail.end_at_cdt',
                        'schedule_header.date_start_shd',
                        'schedule_header.date_end_shd',
                        DB::raw("(select count(distinct(sos.serial_std))
		                                    from student_optional_subject sos
		                                    join period prd on prd.serial_prd=sos.serial_prd
			                                    AND prd.start_date_prd <= now() 
			                                    AND prd.end_date_prd >= now()
                                            join student_year sty on sty.serial_std=sos.serial_std
			                                    AND sty.status_sty !='RETIRED'
			                                    AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')
                                            join student std on std.serial_std=sty.serial_std
			                                    AND std.gender_std='MALE'    
		                                    where status_sos='ACTIVE'
		                                    AND sos.serial_osb=optional_subject.serial_osb) as total_students_male"),
                        DB::raw("(select count(distinct(sos.serial_std))
		                                    from student_optional_subject sos
		                                    join period prd on prd.serial_prd=sos.serial_prd
			                                    AND prd.start_date_prd <= now() 
			                                    AND prd.end_date_prd >= now()
                                            join student_year sty on sty.serial_std=sos.serial_std
			                                    AND sty.status_sty !='RETIRED'
			                                    AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')
                                            join student std on std.serial_std=sty.serial_std
			                                    AND std.gender_std='FEMALE'    
		                                    where status_sos='ACTIVE'
		                                    AND sos.serial_osb=optional_subject.serial_osb) as total_students_female")

                    )
            )
            ->orderBy('start_at_cdt')
            ->get();
        return $result;


    }

}
