<?php


namespace App\Repository;
use App\Contracts\Service\Subjects\SubjectsEmployeeInterface;
use Illuminate\Support\Facades\DB;

class SubjectsInYearByTeacherRepository implements SubjectsEmployeeInterface
{
    public function subjectsEmployee($serialScy, $serialEmp)
    {
        $result = DB::table('subject_course_period as scp')
            ->join('subject_course as sbc', 'sbc.serial_sbc', '=', 'scp.serial_sbc')
            ->join('subject as sbj', 'sbj.serial_sbj', '=', 'sbc.serial_sbj')
            ->join('cat_subject as csb', 'csb.serial_csb', '=', 'sbj.serial_csb')
            ->leftJoin('cat_subject as cs2', 'cs2.serial_csb', '=', 'csb.cat_serial_csb')
            ->join('course as crs', 'crs.serial_crs', '=', 'sbc.serial_crs')
            ->join('level as lvl', 'lvl.serial_lvl', '=', 'crs.serial_lvl')
            ->join('class_group as clg', 'crs.serial_clg', '=', 'clg.serial_clg')
            ->join('level_section_year as lsy', function ($join) {
                $join->on('lsy.serial_lvl', '=', 'lvl.serial_lvl')
                    ->on('lsy.serial_set', '=', 'crs.serial_set')
                    ->on('lsy.serial_scy', '=', 'crs.serial_scy');
            })
            //->join('school_year as syr', 'syr.serial_scy', '=', 'crs.serial_scy')
            ->join('school_year as syr', function ($join) use($serialScy,$serialEmp){
                $join->on('syr.serial_scy', '=', 'crs.serial_scy')
                    ->where('sbc.status_sbc', '=', 'ACTIVE')
                    ->where('sbj.status_sbj', '=', 'ACTIVE')
                    ->where('csb.status_csb', '=', 'ACTIVE')
                    ->where('scp.status_scp', '=', 'ACTIVE')
                    ->where('syr.serial_scy', '=', $serialScy)
                    ->where('sbc.serial_emp', '=', $serialEmp);
            })
            ->leftJoin('year_subject_skills as yss',function ($join) use($serialScy,$serialEmp){
                $join->on('yss.serial_sbc', '=', 'sbc.serial_sbc')
                    ->where('status_yss', '=', 'ACTIVE');
            })
            ->select(DB::raw(
                "DISTINCT(sbc.serial_sbc),
                    IFNULL(CONCAT(cs2.name_csb,' - ',csb.name_csb),csb.name_csb) as name_csb,
                    csb.code_csb,concat( lvl.name_lvl,' ', clg.name_clg) as name_crs,
                    'Obligatoria' as type_subject,
                    lsy.order_lsy as orden,
                    sbc.has_options as options,
                    sbc.has_discipline as discipline,
                    sbc.has_grades as grades,
                    sbc.has_attendance as attendance,
                    project_sbc as project,
                    sbc.abilities_sbc as abilities,
                    sbc.options_sbc as set_options,
                    lsy.serial_pgy,
                    serial_yss as skills,
                    lvl.alter_name_lvl,
                    clg.name_clg,
                    csb.short_name_csb"
            ),
                DB::raw("(select count(distinct(stc.serial_std))
			                        from student_by_course stc 
			                        join student_year sty on sty.serial_std=stc.serial_std
					                        AND stc.status_stc='ACTIVE'
					                        AND sty.status_sty !='RETIRED'
					                        AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')
                                    join course crs on crs.serial_crs=stc.serial_crs
                                            AND crs.serial_scy=sty.serial_scy
                                    join student std on std.serial_std=sty.serial_std
					                        AND std.gender_std='MALE'
					                where stc.serial_crs=sbc.serial_crs
					                ) as total_students_male"),
                DB::raw("(select count(distinct(stc.serial_std))
			                        from student_by_course stc 
			                        join student_year sty on sty.serial_std=stc.serial_std
					                        AND stc.status_stc='ACTIVE'
					                        AND sty.status_sty !='RETIRED'
					                        AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')
                                    join course crs on crs.serial_crs=stc.serial_crs
                                            AND crs.serial_scy=sty.serial_scy
                                    join student std on std.serial_std=sty.serial_std
					                        AND std.gender_std='FEMALE'
					                where stc.serial_crs=sbc.serial_crs) as total_students_female"))
            ->union(
                DB::table('optional_subject AS osb')
                    ->join('optional_subject_level as osl', function ($join) use($serialScy){
                        $join->on('osl.serial_osb', '=', 'osb.serial_osb')
                            ->where('osl.status_osl', '=', 'ACTIVE')
                            ->where('osl.serial_scy','=',$serialScy);
                    })
                    ->join('level as lvl', 'lvl.serial_lvl', '=', 'osl.serial_lvl')
                    ->join('period_group_year as pgy', function ($join) {
                        $join->on('pgy.serial_pgy', '=', 'osb.serial_pgy')
                            ->where('pgy.status_pgy', '=', 'ACTIVE');
                    })->join('level_section_year as lsy', function ($join) {
                        $join->on('lsy.serial_lvl', '=', 'lvl.serial_lvl')
                            ->on('lsy.serial_set', '=', 'osl.serial_set')
                            ->on('lsy.serial_scy', '=', 'osl.serial_scy');
                    })
                    ->join('school_year as syr', 'syr.serial_scy', '=', 'pgy.serial_scy')
                    ->join('cat_subject as csb', 'csb.serial_csb', '=', 'osb.serial_csb')
                    ->leftJoin('cat_subject as csbj', 'csbj.serial_csb', '=', 'csb.cat_serial_csb')
                    ->where('osb.status_osb', '=', 'ACTIVE')
                    ->where('syr.serial_scy', '=', $serialScy)
                    ->where('osb.serial_emp', '=', $serialEmp)
                    ->select(
                        DB::raw("DISTINCT(osb.serial_osb),
		                IFNULL(CONCAT(csbj.name_csb, ' - ', csb.name_csb),CONCAT(csb.name_csb,' (',lvl.description_lvl,')')) AS name_csb,
		                csb.code_csb,
		                '' as name_crs,
                        'Optativa' as type_subject,
                        lsy.order_lsy as orden,
                        osb.has_options as options,
                        osl.has_discipline as discipline,
                        osl.has_grades as grades,
                        osl.has_attendance as attendance,
                        project_osb as project,
                        osb.abilities_osb as abilities,
                        osl.options_osl as set_options,
                        osb.serial_pgy,
                        'null' as skills,
                        lvl.alter_name_lvl,
                        'GRUPAL' as name_clg,
                        csb.short_name_csb"),
                        DB::raw("(select count(distinct(sos.serial_std))
		                                    from student_optional_subject sos
		                                    join period prd on prd.serial_prd=sos.serial_prd
			                                    AND prd.start_date_prd <= now() 
			                                    AND prd.end_date_prd >= now() 
                                            join student_year sty on sty.serial_std=sos.serial_std
			                                    AND sty.status_sty !='RETIRED'
			                                    AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')
                                            join student std on std.serial_std=sty.serial_std
			                                    AND std.gender_std='MALE'    
		                                    where status_sos='ACTIVE'		                                    
                                                AND sos.serial_osb=osb.serial_osb) as total_students_male"),
                        DB::raw("(select count(distinct(sos.serial_std))
		                                    from student_optional_subject sos
		                                    join period prd on prd.serial_prd=sos.serial_prd
			                                    AND prd.start_date_prd <= now() 
			                                    AND prd.end_date_prd >= now()
                                            join student_year sty on sty.serial_std=sos.serial_std
			                                    AND sty.status_sty !='RETIRED'
			                                    AND (sty.comment_sty is null or sty.comment_sty  !='**LEVEL CHANGE**')
                                            join student std on std.serial_std=sty.serial_std
			                                    AND std.gender_std='FEMALE'    
		                                    where status_sos='ACTIVE'
		                                        AND sos.serial_osb=osb.serial_osb) as total_students_female")


                    )
            )
            ->orderBy('orden')
            ->get();


        return $result;


    }

}
