<?php


namespace App\Repository;

use App\Contracts\Service\Subjects\SubjectsByTeacherWithAverageInterface;
use Illuminate\Support\Facades\DB;

class SubjectsByTeacherWithSubperiodAverageRepository implements SubjectsByTeacherWithAverageInterface
{
    public function subjectsEmployee($serialScy, $serialEmp,$serialSbp)
    {
        $result = DB::table('cat_subject')
            ->select(
                'cat_subject.name_csb',
                'subject_course.serial_sbc as serial_subject',
                'course.serial_crs as course_or_level',
                DB::raw('"MANDATORY" as type_subject'),
                DB::raw('"NONE" as lop'),
                'level.name_lvl',
                DB::raw('(SELECT AVG(DISTINCT(average_sss)) FROM student_by_course stc JOIN student_year sty ON sty.serial_std = stc.serial_std AND stc.status_stc = "ACTIVE" AND sty.status_sty != "RETIRED" AND (sty.comment_sty IS NULL OR sty.comment_sty != "**LEVEL CHANGE**") AND stc.serial_crs = course.serial_crs JOIN student std ON std.serial_std = sty.serial_std AND std.gender_std = "MALE" JOIN student_subject_subperiod_average ssa ON ssa.serial_std = std.serial_std AND subject_course.serial_sbc = ssa.serial_sbc) as avg_students_male'),
                DB::raw('(SELECT AVG(DISTINCT(average_sss)) FROM student_by_course stc JOIN student_year sty ON sty.serial_std = stc.serial_std AND stc.status_stc = "ACTIVE" AND sty.status_sty != "RETIRED" AND (sty.comment_sty IS NULL OR sty.comment_sty != "**LEVEL CHANGE**") AND stc.serial_crs = course.serial_crs JOIN student std ON std.serial_std = sty.serial_std AND std.gender_std = "MALE" JOIN student_subject_subperiod_average ssa ON ssa.serial_std = std.serial_std AND subject_course.serial_sbc = ssa.serial_sbc) as avg_students_male'),
                DB::raw('(SELECT AVG(DISTINCT(average_sss)) FROM student_by_course stc JOIN student_year sty ON sty.serial_std = stc.serial_std AND stc.status_stc = "ACTIVE" AND sty.status_sty != "RETIRED" AND (sty.comment_sty IS NULL OR sty.comment_sty != "**LEVEL CHANGE**") AND stc.serial_crs = course.serial_crs JOIN student std ON std.serial_std = sty.serial_std AND std.gender_std = "MALE" JOIN student_subject_subperiod_average ssa ON ssa.serial_std = std.serial_std AND subject_course.serial_sbc = ssa.serial_sbc) as avg_students_male')
            )
            ->join('subject', 'subject.serial_csb', '=', 'cat_subject.serial_csb')
            ->join('subject_course', 'subject_course.serial_sbj', '=', 'subject.serial_sbj')
            ->where('subject_course.serial_emp', $serialEmp)
            ->where('subject_course.status_sbc', 'ACTIVE')
            ->where('subject.status_sbj', 'ACTIVE')
            ->where('cat_subject.status_csb', 'ACTIVE')
            ->join('course', 'course.serial_crs', '=', 'subject_course.serial_crs')
            ->where('course.serial_scy', $serialScy)
            ->join('level', 'level.serial_lvl', '=', 'course.serial_lvl')
            ->join('class_group', 'class_group.serial_clg', '=', 'course.serial_clg')
            ->union(
                DB::table('cat_subject')
                    ->select(
                        'cat_subject.name_csb',
                        'optional_subject.serial_osb as serial_subject',
                        'optional_subject_level.serial_lvl as course_or_level',
                        DB::raw('"OPTIONAL" as type_subject'),
                        'level_optional_group.serial_lop as lop',
                        'level.name_lvl',
                        DB::raw('(SELECT COUNT(DISTINCT(sos.serial_std)) FROM student_optional_subject sos JOIN period prd ON prd.serial_prd = sos.serial_prd AND prd.start_date_prd <= NOW() AND prd.end_date_prd >= NOW() AND sos.serial_osb = optional_subject.serial_osb JOIN student_year sty ON sty.serial_std = sos.serial_std AND sty.status_sty != "RETIRED" AND (sty.comment_sty IS NULL OR sty.comment_sty != "**LEVEL CHANGE**") JOIN student std ON std.serial_std = sty.serial_std AND std.gender_std = "MALE" WHERE status_sos = "ACTIVE") as total_students_male'),
                        DB::raw('(SELECT COUNT(DISTINCT(sos.serial_std)) FROM student_optional_subject sos JOIN period prd ON prd.serial_prd = sos.serial_prd AND prd.start_date_prd <= NOW() AND prd.end_date_prd >= NOW() AND sos.serial_osb = optional_subject.serial_osb JOIN student_year sty ON sty.serial_std = sos.serial_std AND sty.status_sty != "RETIRED" AND (sty.comment_sty IS NULL OR sty.comment_sty != "**LEVEL CHANGE**") JOIN student std ON std.serial_std = sty.serial_std AND std.gender_std = "FEMALE" WHERE status_sos = "ACTIVE") as total_students_female')
                    )
                    ->join('optional_subject', 'optional_subject.serial_csb', '=', 'cat_subject.serial_csb')
                    ->join('optional_subject_level', function ($join) use($serialScy){
                        $join->on('optional_subject_level.serial_osb','=','optional_subject.serial_osb')
                             ->where('optional_subject_level.serial_scy','=',$serialScy);
                    })
                    ->join('group_optional_subject', 'group_optional_subject.serial_osb', '=', 'optional_subject.serial_osb')
                    ->where('group_optional_subject.status_gos', 'ACTIVE')
                    ->join('level_optional_group', 'level_optional_group.serial_lop', '=', 'group_optional_subject.serial_lop')
                    ->where('level_optional_group.status_lop', 'ACTIVE')
                    ->join('level', 'level.serial_lvl', '=', 'optional_subject_level.serial_lvl')
                    ->where('optional_subject_level.status_osl', 'ACTIVE')
                    ->where('optional_subject.status_osb', 'ACTIVE')
                    ->where('cat_subject.status_csb', 'ACTIVE')
                    ->where('optional_subject.serial_emp', $serialEmp)
            )
            ->get();
        return $result;


    }

}
