<?php


namespace App\Repository;


use App\Contracts\SubMenuProfileInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\Process;

class SubProcessRepository implements SubMenuProfileInterface
{

    public function __construct(Process $process)
    {
        $this->process = $process;
    }

    public function submenu($serialPrf,$serialPrc)
    {
        return $this->process->join('profile_process as ppr','ppr.serial_prc','=','process.serial_prc')
            ->where('process.prc_serial_prc','=',$serialPrc)
            ->where('ppr.serial_prf','=',$serialPrf)
            ->where('status_ppr','=','ACTIVE')
            ->where('status_prc','=','LOCKABLE')
            ->groupBy('process.serial_prc')
            ->orderBy('weight_prc')
            ->get();
    }
}
