<?php


namespace App\Repository;
use App\Contracts\Repository\StudentSubperiodAverageSubjectCourseInterface;
use App\Models\StudentSubjectSubperiodAverage;
use Illuminate\Support\Facades\DB;

class StudentSubperiodAverageSubjectCourseRepository implements StudentSubperiodAverageSubjectCourseInterface
{
    public function __construct(StudentSubjectSubperiodAverage $studentSubjectSubperiodAverage)
    {
        $this->studentSubjectSubperiodAverage = $studentSubjectSubperiodAverage;
    }

    public function  getAverageSubperiodSubjectCourseStudent($serialSbp,$serialSbc,$serialStd,$activeRetired)
    {
        $result=$this->studentSubjectSubperiodAverage
                     ->join('student_by_course as stc',function ($join) use($serialSbc){
                         $join->on('stc.serial_std','=','student_subject_subperiod_average.serial_std')
                         ->where('student_subject_subperiod_average.serial_sbc','=',$serialSbc);
                     })->join('course as crs',function ($join) use($serialSbc){
                         $join->on('crs.serial_crs','=','stc.serial_crs')
                              ->on('student_subject_subperiod_average.serial_scy','=','crs.serial_scy');
                     });
        if($activeRetired='ACTIVE'){
            $result=$result->where('status_stc','=','ACTIVE');
        }elseif($activeRetired='RETIRED'){
            $result=$result->where('status_stc','=','RETIRED');
        }
        $result=$result->join('student_year as sty',function ($join){
            $join->on('sty.serial_std','=','stc.serial_std')
                 ->on('sty.serial_scy','=','student_subject_subperiod_average.serial_scy')
                 ->whereRaw('(sty.comment_sty is null or sty.comment_sty  !="**LEVEL CHANGE**")');
        });
        if($activeRetired='ACTIVE'){
            $result=$result->where('status_sty','=','REGISTERED');
        }
        if($serialStd != 'ALL'){
            $result=$result->where('stc.serial_std','=',$serialStd);
        }

        $result=$result->where('serial_sbp','=',$serialSbp)
                       ->get();


        return $result;


    }

}
