<?php


namespace App\Repository;


use App\Contracts\MenuServiceInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\SessionsBetweenVersions\SessionsBetweenVersionsInterface;
use App\Models\SessionsBetweenVersions;
use Illuminate\Support\Facades\DB;

class SessionsBetweenVersionsRepository implements ReadOnlyInterface, SessionsBetweenVersionsInterface
{

    public function __construct(SessionsBetweenVersions $sessionsBetweenVersions)
    {
        $this->sessionsBetweenVersions = $sessionsBetweenVersions;
    }

    public function getOne($serial)
    {
        return $this->sessionsBetweenVersions->find($serial);
    }

    public function getAll()
    {
        return $this->sessionsBetweenVersions->all();
    }

    public function getAllActive()
    {
        return $this->sessionsBetweenVersions->where('status_prc', '=', 'ACTIVE')->get();
    }

    public function getActiveByName($name)
    {
        return false;
    }

    public function getInitialToken($serialUsr, $initialToken)
    {
        return $this->sessionsBetweenVersions->where('serial_usr', '=', $serialUsr)
            ->where('initial_token_sbv', '=', $initialToken)
            ->where('status_sbv', '=', 'ACTIVE')
            ->first();
    }

    public function getLifeToken($serialUsr, $lifeToken)
    {
        return $this->sessionsBetweenVersions->where('serial_usr', '=', $serialUsr)
            ->where('life_token_sbv', '=', $lifeToken)
            ->where('status_sbv', '=', 'ACTIVE')
            ->first();
    }

    public function updateLifeToken($serialUsr, $initialToken, $lifeToken, $statusToken)
    {
        $arrayUpdate = [
            'initial_token_sbv' => NULL,
            'life_token_sbv' => $lifeToken,
        ];
        if ($initialToken) {
            $arrayUpdate['date_create_life_token_sbv'] = date("Y-m-d h:i:s");
            $arrayUpdate['date_update_initial_token_sbv'] = date("Y-m-d h:i:s");
        }

        if ($statusToken) $arrayUpdate['status_sbv'] = $statusToken;
        if ($lifeToken) $arrayUpdate['date_update_life_token_sbv'] = date("Y-m-d h:i:s");

        $result = $this->sessionsBetweenVersions->where('serial_usr', '=', $serialUsr);

        if ($initialToken) {
            $result = $result->where('initial_token_sbv', '=', $initialToken);
        }
        if ($lifeToken && !$initialToken) {
            $result = $result->where('life_token_sbv', '=', $lifeToken);
        }

        $result = $result->update($arrayUpdate);

        return $result;

    }

}
