<?php


namespace App\Repository\Section;



use App\Contracts\Section\SectionByYearInterface;
use App\Models\Section;
use Illuminate\Support\Facades\DB;

class SectionByYearRepository implements SectionByYearInterface
{

    public function __construct(Section $section)
    {
        $this->section = $section;
    }


    public function getSectionsByYear($serialScy)
    {
        return $this->section->join('level_section_year as lsy',function ($join) use($serialScy){
            $join->on('lsy.serial_set','=','section.serial_set')
                 ->where('status_lsy','=','ACTIVE')
                 ->where('status_set','=','ACTIVE')
                 ->where('serial_scy','=',$serialScy);
        })->selectRaw('section.*')
          ->orderBy('section.serial_set')
          ->groupBy('section.serial_set')
          ->get();
    }

}
