<?php


namespace App\Repository;


use App\Contracts\MenuServiceInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\SchoolYear\SchoolYearInterface;
use App\Models\SchoolYear;
use Illuminate\Support\Facades\DB;

class SchoolYearRepository implements ReadOnlyInterface, SchoolYearInterface
{

    public function __construct(SchoolYear $schoolYear)
    {
        $this->schoolYear = $schoolYear;
    }

    public function getOne($serial)
    {
        return $this->schoolYear->find($serial);
    }

    public function getAll()
    {
        return $this->schoolYear->all();
    }

    public function getAllActive()
    {
        return $this->schoolYear->whereRaw('status_scy like "%ACTIVE%"')->orderBy('start_date_scy','ASC')->get();
    }
    public function getActiveByName($name)
    {
        return $this->schoolYear->where('name_scy', '=', $name)->orderBy('start_date_scy','ASC')->get();
    }
    public function getActiveCurrent()
    {
        return $this->schoolYear->where('status_scy', '=', 'ACTIVE,CURRENT')->orderBy('start_date_scy','ASC')->first();
    }

}
