<?php


namespace App\Repository;


use App\Contracts\MenuServiceInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\Process;
use Illuminate\Support\Facades\DB;

class ProcessRepository implements ReadOnlyInterface,MenuServiceInterface
{

    public function __construct(Process $process)
    {
        $this->process = $process;
    }

    public function getOne($serial)
    {
        return $this->process->find($serial);
    }

    public function getAll()
    {
        return $this->process->all();
    }

    public function getAllActive()
    {
        return $this->process->where('status_prc', '=', 'LOCKABLE')->get();
    }
    public function getActiveByName($name)
    {
        return $this->process->where('name_prc', '=', $name)->where('status_prc', '=', 'LOCKABLE')->get();
    }

    public function menu()
    {
        return $this->process->whereRaw("link_prc = '#'")
            ->whereRaw('prc_serial_prc is NULL')
            ->orderBy('weight_prc')
            ->groupBy('serial_prc')
            ->get();
    }

    public function submenu($serial_prc)
    {
        return $this->where('prc_serial_prc','=',$serial_prc)
                            ->orderBy('weight_prc')
                            ->get();
    }
    public function menuOld($serial_prf)
    {

        $sql = "(SELECT prc.serial_prc, prc.name_prc, prc.link_prc, prc.prc_serial_prc, prc.weight_prc,system_version_prc
							FROM process prc
							WHERE prc.serial_prc
							IN (
									SELECT pn.prc_serial_prc
									FROM (
											  SELECT DISTINCT p.serial_prc, p.name_prc, p.link_prc, p.prc_serial_prc, p.weight_prc
											  FROM process p
											  WHERE p.serial_prc
											  IN (
													  SELECT pc.prc_serial_prc
													  FROM profile_process pp, process pc
													  WHERE pp.serial_prc = pc.serial_prc and pp.status_ppr!='INACTIVE'
													  AND serial_prf = ".$serial_prf."
													  ORDER BY pc.serial_prc
												 )
									  )pn
								 )
							)UNION
							(SELECT prc.serial_prc, prc.name_prc, prc.link_prc, prc.prc_serial_prc, prc.weight_prc,system_version_prc
							FROM process prc
							WHERE prc.serial_prc
							IN (
								SELECT prc.prc_serial_prc
								FROM process prc
								WHERE prc.serial_prc
								IN(
									SELECT pn.prc_serial_prc
									FROM (
											  SELECT DISTINCT p.serial_prc, p.name_prc, p.link_prc, p.prc_serial_prc, p.weight_prc
											  FROM process p
											  WHERE p.serial_prc
											  IN (
													  SELECT pc.prc_serial_prc
													  FROM profile_process pp, process pc
													  WHERE pp.serial_prc = pc.serial_prc and pp.status_ppr!='INACTIVE'
													  AND serial_prf = ".$serial_prf."
													  ORDER BY pc.serial_prc
												 )
									  )pn
								 )
							   )
							)UNION
							(SELECT DISTINCT p.serial_prc, p.name_prc, p.link_prc, p.prc_serial_prc, p.weight_prc,system_version_prc
							FROM process p
							WHERE p.serial_prc
							IN (
									SELECT p.prc_serial_prc
									FROM profile_process pp, process p
									WHERE pp.serial_prc = p.serial_prc and pp.status_ppr!='INACTIVE'
									AND serial_prf =".$serial_prf."
									ORDER BY p.serial_prc
							   )
							)
							UNION
							(SELECT p.serial_prc, p.name_prc, p.link_prc, p.prc_serial_prc, p.weight_prc,system_version_prc
							FROM profile_process pp, process p
							WHERE pp.serial_prc = p.serial_prc  and pp.status_ppr!='INACTIVE'
							AND serial_prf =".$serial_prf."
							ORDER BY p.serial_prc)
							ORDER BY prc_serial_prc,weight_prc";

        $result = DB::select(DB::raw($sql)->getValue(DB::connection()->getQueryGrammar()));

        return $result;
    }
}
