<?php


namespace App\Repository\Models;

use App\Contracts\Repository\UserLearnboxInterface;
use App\Models\UserLearnbox;
use Illuminate\Support\Facades\DB;

class UserLearnboxRepository implements UserLearnboxInterface
{

    public function __construct(UserLearnbox $userLearnbox)
    {
        $this->userLearnbox = $userLearnbox;
    }

    public function getUserDataBySerialUsr($serial_usr)
    {
        //sirvase añadir mas campos si lo necesitan, tener cuidado en añadir los respectivos alias para que los campos con nombres igual en diferente tablas no sean ambiguos al intentar acceder a ellos
        $result=$this->userLearnbox->leftJoin('employee as e','e.serial_usr','=','user.serial_usr')
                     ->leftJoin('guardian as g','g.serial_usr','=','user.serial_usr')
                     ->leftJoin('student as s' ,'s.serial_usr','=','user.serial_usr')
                     ->where('user.serial_usr','=',$serial_usr)
                     ->select(
                            DB::raw('user.serial_usr, user.username_usr,user.photo_usr,user.change_pass_usr,user.status_usr,user.accept_terms_conditions,user.updated_data,user.google_token'),
                            DB::raw("if(user.serial_std IS NULL, IF(user.serial_grd IS NULL && user.serial_emp IS NOT NULL ,IF(user.serial_emp IS NULL && user.serial_grd IS NOT NULL,IF(user.serial_emp IS NOT NULL && user.serial_grd IS NOT NULL,'NONE','GUARDIAN_EMPLOYEE'),'GUARDIAN'),'EMPLOYEE'),'STUDENT') as type_user"),
                            DB::raw("e.serial_emp,e.serial_ste as serial_ste_emp,e.serial_cou as serial_cou_emp,e.serial_nnt as serial_nnt_emp,e.id_emp,e.code_emp,e.first_name_emp,e.last_name_emp,e.alternate_name_emp,e.specialty_emp,e.gender_emp,e.marital_status_emp,e.birthdate_emp,e.address_emp,e.city_emp,e.phone_emp,e.cellphone_emp,e.email_emp"),
                            DB::raw("g.serial_grd,g.id_grd,g.first_name_grd,g.last_name_grd,g.birthdate_grd,g.marital_status_grd,g.email_grd,g.status_grd"),
                            DB::raw("s.serial_fml,s.serial_std,s.id_std,s.first_name_std,s.last_name_std,s.birthdate_std,s.gender_std,s.marital_status_std,s.mobile_std,s.email_std,s.status_std,s.lock_grades")
                     )
                     ->first();
        return $result;
    }
}
