<?php


namespace App\Repository\Models;


use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\StatisticProfile;
use Illuminate\Support\Facades\DB;

class StatisticProfileRepository implements ReadOnlyInterface
{

    public function __construct(StatisticProfile $statisticProfile)
    {
        $this->statisticProfile = $statisticProfile;
    }

    public function getOne($serial)
    {
        return $this->statisticProfile->find($serial);
    }

    public function getAll()
    {
        return $this->statisticProfile->all();
    }

    public function getAllActive()
    {
        return $this->statisticProfile->where('status_stp', '=', 'ACTIVE')->get();
    }
    public function getActiveByName($name){
        return $this->statisticProfile->where('name_stp', '=', $name)->where('status_stp', '=', 'ACTIVE')->get();
    }
}
