<?php


namespace App\Repository\Models;


use App\Contracts\MenuServiceInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\Section;
use Illuminate\Support\Facades\DB;

class SectionRepository implements ReadOnlyInterface
{

    public function __construct(Section $section)
    {
        $this->section = $section;
    }

    public function getOne($serial)
    {
        return $this->section->find($serial);
    }

    public function getAll()
    {
        return $this->section->all();
    }

    public function getAllActive()
    {
        return $this->section->whereRaw('status_set like "ACTIVE"')->orderBy('serial_set','ASC')->get();
    }
    public function getActiveByName($name){
        return $this->section->where('name_set', '=', $name)->where('status_set', '=', 'ACTIVE')->get();
    }
}
