<?php


namespace App\Repository\Models;


use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\SchoolFlag;
use Illuminate\Support\Facades\DB;

class SchoolFlagRepository implements ReadOnlyInterface
{

    public function __construct(SchoolFlag $schoolFlag)
    {
        $this->schoolFlag = $schoolFlag;
    }

    public function getOne($serial)
    {
        return $this->schoolFlag->find($serial);
    }

    public function getAll()
    {
        return $this->schoolFlag->all();
    }

    public function getAllActive()
    {
        return $this->schoolFlag->where('status_scf', '=', 'ACTIVE')->get();
    }
    public function getActiveByName($name){
        return $this->schoolFlag->where('name_scf', '=', $name)->where('status_scf', '=', 'ACTIVE')->get();
    }
}
