<?php


namespace App\Repository\Models;


use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\FlagDropdownProcess;
use Illuminate\Support\Facades\DB;

class FlagDropdownProcessRepository implements ReadOnlyInterface
{

    public function __construct(FlagDropdownProcess $flagDropdownProcess)
    {
        $this->flagDropdownProcess = $flagDropdownProcess;
    }

    public function getOne($serial)
    {
        return $this->flagDropdownProcess->find($serial);
    }

    public function getAll()
    {
        return $this->flagDropdownProcess->all();
    }

    public function getAllActive()
    {
        return $this->flagDropdownProcess->where('status_fdp', '=', 'ACTIVE')->get();
    }
    public function getActiveByName($name){
        return false;
    }
}
