<?php


namespace App\Repository\Models;


use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\FlagDropdownBar;
use Illuminate\Support\Facades\DB;

class FlagDropdownBarRepository implements ReadOnlyInterface
{

    public function __construct(FlagDropdownBar $flagDropdownBar)
    {
        $this->flagDropdownBar = $flagDropdownBar;
    }

    public function getOne($serial)
    {
        return $this->flagDropdownBar->find($serial);
    }

    public function getAll()
    {
        return $this->flagDropdownBar->all();
    }

    public function getAllActive()
    {
        return $this->flagDropdownBar->where('status_dfb', '=', 'ACTIVE')->get();
    }
    public function getActiveByName($name){
        return $this->flagDropdownBar->where('name_dfb', '=', $name)->where('status_dfb', '=', 'ACTIVE')->get();
    }
}
