<?php


namespace App\Repository\Models;



use App\Contracts\Repository\FlagYearInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\DateDayConfiguration;
use Illuminate\Support\Facades\DB;

class DateDayConfigurationRepository implements ReadOnlyInterface
{

    public function __construct(DateDayConfiguration $dateDayConfiguration)
    {
        $this->dateDayConfiguration = $dateDayConfiguration;
    }

    public function getOne($serial)
    {
        return $this->dateDayConfiguration->find($serial);
    }

    public function getAll()
    {
        return $this->dateDayConfiguration->all();
    }

    public function getAllActive()
    {
        return $this->dateDayConfiguration->where('status_ddc', '=', 'ACTIVE')->get();
    }
    public function getActiveByName($name){
        return $this->dateDayConfiguration->where('date_ddc', '=', $name)->where('status_ddc', '=', 'ACTIVE')->get();
    }
}
