<?php


namespace App\Repository\Models;




use App\Contracts\Repository\ReadOnlyInterface;
use App\Models\Activity;
use Illuminate\Support\Facades\DB;

class ActivityRepository implements ReadOnlyInterface
{

    public function __construct(Activity $activity)
    {
        $this->activity = $activity;
    }

    public function getOne($serial)
    {
        return $this->activity->find($serial);
    }

    public function getAll()
    {
        return $this->activity->all();
    }

    public function getAllActive()
    {
        return $this->activity->where('status_act', '=', 'ACTIVE')->get();
    }
    public function getActiveByName($name)
    {
        return $this->activity->where('name_act', '=', $name)->where('status_act', '=', 'ACTIVE')->get();
    }

}
