<?php


namespace App\Repository;



use App\Contracts\Repository\FlagYearInterface;
use App\Models\SchoolFlag;
use Illuminate\Support\Facades\DB;

class FlagYearRepository implements FlagYearInterface
{

    public function __construct(SchoolFlag $schoolFlag)
    {
        $this->schoolFlag = $schoolFlag;
    }

    public function flagYear($type_scf,$name_scf,$serial_scy)
    {
        return $this->schoolFlag->join('flag_year as fly','fly.serial_scf','=','school_flag.serial_scf')
            ->where('type_scf','=',$name_scf)
            ->where('school_flag.type_scf','=',$type_scf)
            ->where('fly.serial_scy','=',$serial_scy)
            ->where('status_scf','=','ACTIVE')
            ->where('status_fly','=','ACTIVE')
            ->first();
    }

}
