<?php


namespace App\Repository\Flag;


use App\Contracts\Repository\Flag\FlagDropdownProcessInterface;
use App\Models\Process;
use Illuminate\Support\Facades\DB;
use function PHPUnit\Framework\result;

class FlagToProcessRepository implements FlagDropdownProcessInterface
{

    public function __construct(Process $process)
    {
        $this->process = $process;
    }

    //app/Repository/DateTodayRepository.php
    /**
     * @author Diego Navarrete
     * @date 2023-11-19
     * @serviceProvider
     * @description metodo que regresa las banderas configuradas para el dropdown segun el proceso
     */
    public function flagsDropdownProcess($process,$nameFlag)
    {
        $result= $this->process->join('flag_dropdown_process as fdp',function ($join) use($process){
            $join->on('process.serial_prc','=','fdp.serial_prc')
                 ->where('process.link_prc','=',$process)
                 ->where('process.status_prc','=','LOCKABLE');
        })->join('flag_dropdown_bar as fdb',function ($join) use($process){
            $join->on('fdp.serial_fdb','=','fdb.serial_fdb')
                 ->where('status_fdp','=','ACTIVE')
                 ->where('status_dfb','=','ACTIVE');
        });

        if($nameFlag=='ALL'){
            $result= $result->get();
        }else{
            $result= $result->whereRaw('name_dfb like "%'.$nameFlag.'%"')->get();
        }
        return $result;
    }
}
