<?php


namespace App\Repository;


use App\Contracts\Repository\DateTodayInterface;
use App\Models\DateDayConfiguration;
use Illuminate\Support\Facades\DB;

class DateTodayRepository implements DateTodayInterface
{

    public function __construct(DateDayConfiguration $dateDayConfiguration)
    {
        $this->dateDayConfiguration = $dateDayConfiguration;
    }

    //app/Repository/DateTodayRepository.php
    /**
     * @author Diego Navarrete
     * @date 2023-11-14
     * @serviceProvider
     * @description metodo que regresa el dia y fecha actual
     * @param DateTodayInterface $dateToday -> app/Repository/DateTodayRepository.php
     */
    public function todayDateDay()
    {
        return $this->dateDayConfiguration
            ->where('status_ddc', '=', 'ACTIVE')
            ->whereRaw('date_ddc = now()')
            ->first();
    }
}
