<?php


namespace App\Repository;


use App\Contracts\Repository\ActivityMandatorySubjectInterface;
use App\Models\Activity;
use Illuminate\Support\Facades\DB;

class ActivityMandatorySubjectRepository implements ActivityMandatorySubjectInterface
{

    public function __construct(Activity $activity)
    {
        $this->activity = $activity;
    }

    //app/Repository/DateTodayRepository.php
    /**
     * @author Diego Navarrete
     * @date 2023-11-23
     * @description metodo que regresa las actividades de una materia
     * @param DateTodayInterface $dateToday -> app/Repository/DateTodayRepository.php
     */
    public function activityBySubject($serialSbc,$serialPrd,$serialSbp)
    {
        $result= $this->activity->join('activity_applied_criterias as apc', function ($join) {
                $join->on('apc.serial_act', '=', 'activity.serial_act')
                    ->where('activity.status_act', '=', 'ACTIVE')
                    ->where('apc.status_aac', '=', 'ACTIVE');
            });
        if($serialPrd>0 && $serialPrd!='ALL'){
            $result= $result->join('period as prd',function ($join){
                $join->on('prd.serial_prd','=','apc.serial_prd')
                     ->where('prd.status_prd','=','ACTIVE')
                     ->whereRaw("concat(prd.start_date_prd, ' 00:00:00') <= act.due_date_act AND concat(prd.end_date_prd, ' 23:59:59') >= act.due_date_act " );
            });
            if($serialSbp>0 && $serialSbp!='ALL'){
                $result= $result->join('subperiod as sbp',function ($join){
                    $join->on('sbp.serial_prd','=','prd.serial_prd')
                        ->where('sbp.status_sbp','=','ACTIVE')
                        ->whereRaw("concat(sbp.start_date_sbp, ' 00:00:00') <= act.due_date_act AND concat(sbp.end_date_sbp, ' 23:59:59') >= act.due_date_act" );
                });
            }
        }
        return $result;
    }
}
