<?php

namespace App\Providers;
use App\Classes\SubProcessUser;
use App\Classes\Token\LifeToken;
use App\Contracts\MenuServiceInterface;
use App\Contracts\Repository\UserLearnboxInterface;
use App\Contracts\Repository\VerifyAllowedPagesProcessRepositoryInterface;
use App\Contracts\Security\LifeTokenInterface;
use App\Contracts\Security\VerifyAllowedPagesProcessInterface;
use App\Contracts\SubMenuProfileInterface;
use App\Http\Middleware\PermissionMiddleware;
use App\Http\Middleware\ValidateInitialToken;
use App\Repository\Models\UserLearnboxRepository;
use App\Repository\ProcessRepository;
use App\Repository\VerifyAllowedProcessRepository;
use App\Service\MenuService;
use App\Service\Security\TokenRandomGenerateService;
use App\Service\Security\VerifyAllowedPagesProcessService;
use Illuminate\Support\ServiceProvider;

class ServicesRutatecServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Services*/
        $this->app->when(TokenRandomGenerateService::class)
            ->needs(LifeTokenInterface::class)
            ->give(LifeToken::class);

        $this->app->when(MenuService::class)
            ->needs(MenuServiceInterface::class)
            ->give(ProcessRepository::class);

        $this->app->when(MenuService::class)
            ->needs(SubMenuProfileInterface::class)
            ->give(SubProcessUser::class);

        $this->app->when(ValidateInitialToken::class)
            ->needs(UserLearnboxInterface::class)
            ->give(UserLearnboxRepository::class);

        $this->app->when(PermissionMiddleware::class)
            ->needs(VerifyAllowedPagesProcessInterface::class)
            ->give(VerifyAllowedPagesProcessService::class);

        $this->app->when(VerifyAllowedPagesProcessService::class)
            ->needs(VerifyAllowedPagesProcessRepositoryInterface::class)
            ->give(VerifyAllowedProcessRepository::class);


    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
