<?php

namespace App\Providers\Service;

use App\Contracts\Repository\DateTodayInterface;
use App\Contracts\Repository\StudentSubperiodAverageSubjectCourseInterface;
use App\Contracts\Repository\SubperiodAverageOptionalSubjectInterface;
use App\Contracts\Repository\SubperiodAverageSubjectInterface;
use App\Repository\DateTodayRepository;
use App\Repository\SubperiodAverageOptionalSubjectRepository;
use App\Repository\SubperiodAverageSubjectRepository;
use App\Service\Average\SubperiodAverageService;
use App\Repository\StudentSubperiodAverageSubjectCourseRepository;
use Illuminate\Support\ServiceProvider;

class SubperiodAvergaeServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {

        $this->app->when(SubperiodAverageService::class)
            ->needs(StudentSubperiodAverageSubjectCourseInterface::class)
            ->give(StudentSubperiodAverageSubjectCourseRepository::class);

        $this->app->when(SubperiodAverageService::class)
            ->needs(SubperiodAverageSubjectInterface::class)
            ->give(SubperiodAverageSubjectRepository::class);

        $this->app->when(SubperiodAverageService::class)
            ->needs(SubperiodAverageOptionalSubjectInterface::class)
            ->give(SubperiodAverageOptionalSubjectRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
