<?php

namespace App\Providers\Service;

use App\Contracts\Repository\SubjectsScheduleByTeacherDayInterface;
use App\Contracts\Service\Subjects\SubjectsEmployeeInterface;
use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use App\Http\Controllers\Teacher\HomeTeacherController;
use App\Repository\SubjectsScheduleByTeacherDayRepository;
use App\Service\Subjects\SubjectsScheduleByUserAndDayService;
use App\Service\Subjects\SubjectsUserYearService;
use App\Repository\SubjectsInYearByTeacherRepository;
use Illuminate\Support\ServiceProvider;

class SubjectsServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Services*/
        $this->app->when(SubjectsUserYearService::class)
            ->needs(SubjectsEmployeeInterface::class)
            ->give(SubjectsInYearByTeacherRepository::class);

        $this->app->when(HomeTeacherController::class)
            ->needs(SubjectsInYearByUserInterface::class)
            ->give(SubjectsUserYearService::class);

        //SCHEDULE
        $this->app->when(SubjectsScheduleByUserAndDayService::class)
            ->needs(SubjectsScheduleByTeacherDayInterface::class)
            ->give(SubjectsScheduleByTeacherDayRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
