<?php

namespace App\Providers\Service;

use App\Contracts\Repository\Flag\FlagDropdownProcessInterface;
use App\Contracts\Repository\FlagSetupInterface;
use App\Contracts\Repository\FlagYearInterface;
use App\Repository\FlagSetupRepository;
use App\Repository\FlagYearRepository;
use App\Service\Flag\FlagConfiguredService;
use App\Service\Flag\FlagDropdownConfiguredService;
use App\Repository\Flag\FlagToProcessRepository;

use Illuminate\Support\ServiceProvider;

class FlagConfiguredServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {

        $this->app->when(FlagConfiguredService::class)
            ->needs(FlagSetupInterface::class)
            ->give(FlagSetupRepository::class);

        $this->app->when(FlagConfiguredService::class)
            ->needs(FlagYearInterface::class)
            ->give(FlagYearRepository::class);

        //Banderas para obtener las configuraciones de dropdown
        $this->app->when(FlagDropdownConfiguredService::class)
            ->needs(FlagDropdownProcessInterface::class)
            ->give(FlagToProcessRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
