<?php

namespace App\Providers\Service;

use App\Contracts\Repository\DateTodayInterface;
use App\Repository\DateTodayRepository;
use App\Service\Date\DateDayService;
use Illuminate\Support\ServiceProvider;

class DateServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->when(DateDayService::class)
            ->needs(DateTodayInterface::class)
            ->give(DateTodayRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
