<?php

namespace App\Providers;
use App\Classes\SubProcessUser;
use App\Classes\Token\LifeToken;
use App\Contracts\MenuServiceInterface;
use App\Contracts\Repository\UserLearnboxInterface;
use App\Contracts\Security\LifeTokenInterface;
use App\Contracts\SubMenuProfileInterface;
use App\Http\Middleware\PermissionMiddleware;
use App\Http\Middleware\ValidateInitialToken;
use App\Repository\Models\UserLearnboxRepository;
use App\Repository\ProcessRepository;
use App\Service\MenuService;
use App\Service\Security\TokenRandomGenerateService;
use Illuminate\Support\ServiceProvider;

class MiddlewareServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Services*/
        $this->app->when(PermissionMiddleware::class)
            ->needs(MenuServiceInterface::class)
            ->give(MenuService::class);

    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
