<?php

namespace App\Providers;

use App\Classes\SubProcessUser;
/*--- Contracts ---*/

use App\Classes\Token\LifeToken;
use App\Contracts\MenuServiceInterface;
use App\Contracts\SchoolSetup\SchoolSetupInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\Security\EncryptDecryptInterface;
use App\Contracts\Security\LifeTokenInterface;
use App\Contracts\Security\SessionInterface;
use App\Contracts\Security\TokenRandomGenerateInterface;
use App\Contracts\SessionsBetweenVersions\SessionsBetweenVersionsInterface;
use App\Contracts\SubMenuProfileInterface;
/*--- Controllers ---*/
use App\Http\Controllers\MenuController;
/*--- Repository ---*/

use App\Http\Middleware\ValidateInitialToken;
/*--- Repository ---*/
use App\Repository\ProcessRepository;
use App\Repository\SchoolSetupRepository;
use App\Repository\SessionsBetweenVersionsRepository;

/*--- Service ---*/
use App\Service\Security\EncryptService;
use App\Service\MenuService;


/*--- Other ---*/

use App\Service\SessionService;
use App\Service\Security\TokenRandomGenerateService;
use Illuminate\Support\ServiceProvider;
use App\Http\ViewComposers\MenuComposer;

class ControllerRutatecServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
