<?php

namespace App\Providers\Controller;


use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use App\Http\Controllers\Teacher\TeacherGradeEntryController;
use App\Service\Subjects\SubjectsUserYearService;
use Illuminate\Support\ServiceProvider;

class TeacherGradeEntryServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Services*/
        $this->app->when(TeacherGradeEntryController::class)
            ->needs(SubjectsInYearByUserInterface::class)
            ->give(SubjectsUserYearService::class);

    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
