<?php

namespace App\Providers\Controller;


use App\Contracts\Repository\SubperiodAverageSubjectInterface;
use App\Contracts\Service\Average\SubperiodAverageServiceInterface;
use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use App\Http\Controllers\Teacher\StatisticTeacherController;
use App\Service\Average\SubperiodAverageService;
use App\Service\Subjects\SubjectsUserYearService;
use Illuminate\Support\ServiceProvider;

class StatisticTeacherServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Services*/
        $this->app->when(StatisticTeacherController::class)
            ->needs(SubjectsInYearByUserInterface::class)
            ->give(SubjectsUserYearService::class);

        $this->app->when(StatisticTeacherController::class)
            ->needs(SubperiodAverageServiceInterface::class)
            ->give(SubperiodAverageService::class);


    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
