<?php

namespace App\Providers\Controller;

use App\Contracts\Service\Date\DateDayInterface;
use App\Contracts\Service\Flag\FlagConfiguredInterface;
use App\Contracts\Service\Subjects\SubjectsEmployeeInterface;
use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use App\Http\Controllers\Teacher\HomeTeacherController;
use App\Service\Date\DateDayService;
use App\Service\Flag\FlagConfiguredService;
use App\Service\Subjects\SubjectsScheduleByUserAndDayService;
use App\Service\Subjects\SubjectsUserYearService;
use App\Repository\SubjectsInYearByTeacherRepository;
use Illuminate\Support\ServiceProvider;

class HomeServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Services*/
        $this->app->when(SubjectsUserYearService::class)
            ->needs(SubjectsEmployeeInterface::class)
            ->give(SubjectsInYearByTeacherRepository::class);

        $this->app->when(HomeTeacherController::class)
            ->needs(SubjectsInYearByUserInterface::class)
            ->give(SubjectsUserYearService::class);

        $this->app->when(HomeTeacherController::class)
            ->needs(FlagConfiguredInterface::class)
            ->give(FlagConfiguredService::class);

        $this->app->when(HomeTeacherController::class)
            ->needs(SubjectsScheduleByUserAndDayService::class)
            ->give(SubjectsScheduleByUserAndDayService::class);

        $this->app->when(HomeTeacherController::class)
            ->needs(DateDayInterface::class)
            ->give(DateDayService::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
