<?php

namespace App\Providers\Composers;



use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\Service\Section\SectionByYearServiceInterface;
use App\Http\ViewComposers\SectionDropdownPrincipalBarComposer;
use App\Repository\Models\SectionRepository;
use App\Service\Section\SectionByYearService;
use Illuminate\Support\ServiceProvider;
class SectionComposerServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /**
         * Manejo del composer que entrega las secciones por año para armar la navbar de dropdown principal
         *
         */
        $this->app->when(SectionDropdownPrincipalBarComposer::class)
            ->needs(SectionByYearServiceInterface::class)
            ->give(SectionByYearService::class);

        $this->app->when(SectionDropdownPrincipalBarComposer::class)
            ->needs(ReadOnlyInterface::class)
            ->give(SectionRepository::class);


    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
