<?php

namespace App\Providers\Composers;



use App\Contracts\Service\Flag\FlagDropdownProcessServiceInterface;
use App\Http\ViewComposers\FlagConfiguredPrincipalBarComposer;
use App\Service\Flag\FlagDropdownConfiguredService;
use Illuminate\Support\ServiceProvider;
class FlagDropdownComposerServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /**
         * Manejo del composer que entrega el school year para armar la navbar de dropdown principal
         *
         */
        $this->app->when(FlagConfiguredPrincipalBarComposer::class)
            ->needs(FlagDropdownProcessServiceInterface::class)
            ->give(FlagDropdownConfiguredService::class);


    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
