<?php

namespace App\Providers;

use App\Http\ViewComposers\FlagConfiguredPrincipalBarComposer;
use App\Http\ViewComposers\SectionDropdownPrincipalBarComposer;
use Illuminate\Support\ServiceProvider;
use App\Http\ViewComposers\MenuComposer;
use App\Http\ViewComposers\SchoolYearDropdownPrincipalBarComposer;
use Illuminate\Support\Facades;
use Illuminate\View\View;

class ComposerViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //resources/views/layout/dropdownPrincipalBarControl.blade.php
        //registrar a que vista se permite el acceso de MenuComposer
        Facades\View::composer('layout.sidebar', MenuComposer::class);
        Facades\View::composer('layout.dropdownPrincipalBarControl', SchoolYearDropdownPrincipalBarComposer::class);
        Facades\View::composer('layout.dropdownPrincipalBarControl', FlagConfiguredPrincipalBarComposer::class);
        Facades\View::composer('layout.dropdownPrincipalBarControl', SectionDropdownPrincipalBarComposer::class);

    }
}
