<?php

namespace App\Providers;

use App\Classes\SubProcessUser;
/*--- Contracts ---*/

use App\Classes\Token\LifeToken;
use App\Contracts\MenuServiceInterface;
use App\Contracts\SchoolSetup\SchoolSetupInterface;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\Security\EncryptDecryptInterface;
use App\Contracts\Security\LifeTokenInterface;
use App\Contracts\Security\SessionInterface;
use App\Contracts\Security\TokenRandomGenerateInterface;
use App\Contracts\SessionsBetweenVersions\SessionsBetweenVersionsInterface;
use App\Contracts\SubMenuProfileInterface;
/*--- Controllers ---*/
use App\Http\Controllers\MenuController;
/*--- Repository ---*/

use App\Http\Middleware\ValidateInitialToken;
/*--- Repository ---*/
use App\Repository\ProcessRepository;
use App\Repository\SchoolSetupRepository;
use App\Repository\SessionsBetweenVersionsRepository;

/*--- Service ---*/
use App\Service\Security\EncryptService;
use App\Service\MenuService;


/*--- Other ---*/

use App\Service\Security\SessionService;
use App\Service\Security\TokenRandomGenerateService;
use Illuminate\Support\ServiceProvider;
use App\Http\ViewComposers\MenuComposer;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        /*Menu*/
        $this->app->when(MenuService::class)
            ->needs(SchoolSetupInterface::class)
            ->give(SchoolSetupRepository::class);

        $this->app->when(MenuComposer::class)
            ->needs(MenuServiceInterface::class)
            ->give(MenuService::class);

        $this->app->when(MenuComposer::class)
            ->needs(MenuServiceInterface::class)
            ->give(MenuService::class);

        /*Sesion de version laravel  5.4 o smarty*/
        $this->app->when(ValidateInitialToken::class)
            ->needs(TokenRandomGenerateInterface::class)
            ->give(TokenRandomGenerateService::class);

        $this->app->when(ValidateInitialToken::class)
            ->needs(SessionsBetweenVersionsInterface::class)
            ->give(SessionsBetweenVersionsRepository::class);

        /*Sesion de version laravel  5.4 o smarty*/
        $this->app->when(ValidateInitialToken::class)
            ->needs(EncryptDecryptInterface::class)
            ->give(EncryptService::class);

        $this->app->when(ValidateInitialToken::class)
            ->needs(SessionInterface::class)
            ->give(SessionService::class);

        $this->app->when(ValidateInitialToken::class)
            ->needs(TokenRandomGenerateInterface::class)
            ->give(TokenRandomGenerateService::class);

        /*Clases*/
        $this->app->when(LifeToken::class)
            ->needs(SessionsBetweenVersionsInterface::class)
            ->give(SessionsBetweenVersionsRepository::class);


        //app()->bind(MenuServiceInterface::class,MenuService::class);
        $this->app->when(MenuController::class)
                  ->needs(MenuServiceInterface::class)
                  ->give(MenuService::class);


        $this->app->when(SubProcessUser::class)
                  ->needs(ReadOnlyInterface::class)
                  ->give(ProcessRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
