<?php

namespace App\Http\ViewComposers;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\Service\Section\SectionByYearServiceInterface;
use Illuminate\View\View;

class SectionDropdownPrincipalBarComposer
{
    protected  $menuService;

    /**
     * @author Diego Navarrete
     * @date 2023-11-19
     * @description constructor para instanciar interfaces de uso en la clase
     * SchoolYearDropdownPrincipalBarComposer constructor.
     * @param SectionByYearServiceInterface $sectionByYearServiceInterface --> app/Providers/Composers/SectionComposerServiceProvider.php
     * @param ReadOnlyInterface $readOnlyInterface --> Repository/Models/SectionRepository.php
     *
     */
    public function __construct(SectionByYearServiceInterface $sectionByYearService, ReadOnlyInterface $readOnly)
    {
        $this->sectionByYearService=$sectionByYearService;
        $this->readOnlyInterface=$readOnly;
    }


    /**
     * @author Diego Navarrete
     * @date 2023-11-19
     * @description metodo que devuelve la informacion de las secciones al dropdown de la navbar principal
     * SchoolYearDropdownPrincipalBarComposer constructor.
     * @param SectionByYearServiceInterface $sectionByYearServiceInterface --> app/Providers/Composers/SectionComposerServiceProvider.php
     *
     */
    public function compose(View $view): void
    {

        $currentSection=0;
        if(isset($_SESSION['school_year_use'])){
            if(isset($_SESSION['section_use'])){
                $currentSection=$this->readOnlyInterface->getOne($_SESSION['section_use']);
                $currentSection=isset($currentSection->serial_set)?$currentSection->serial_set:0;
            }
            $sectionsByYear=$this->sectionByYearService->getSectionsByYear($_SESSION['school_year_use']);
        }else{
            $sectionsByYear=array();
        }
        $view->with('currentSectionComposer', $currentSection)
             ->with('sectionByYearComposer', $sectionsByYear);
    }
}
