<?php

namespace App\Http\ViewComposers;
use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\SchoolYear\SchoolYearInterface;
use Illuminate\View\View;

class SchoolYearDropdownPrincipalBarComposer
{
    protected  $menuService;

    /**
     * @author Diego Navarrete
     * @date 2023-11-18
     * @description constructor para instanciar interfaces de uso en la clase
     * SchoolYearDropdownPrincipalBarComposer constructor.
     * @param ReadOnlyInterface $readOnlyInterface --> app/Repository/SchoolYearRepository.php
     * @param SchoolYearInterface $schoolYearInterface --> app/Repository/SchoolYearRepository.php
     *
     */
    public function __construct(ReadOnlyInterface $readOnlyInterface, SchoolYearInterface $schoolYearInterface)
    {
        $this->readOnlyInterface=$readOnlyInterface;
        $this->schoolYearInterface=$schoolYearInterface;
    }


    /**
     * @author Diego Navarrete
     * @date 2023-11-18
     * @description metodo que devuelve la informacion del schoolyear al dropdown de la navbar principal
     * SchoolYearDropdownPrincipalBarComposer constructor.
     * @param ReadOnlyInterface $readOnlyInterface --> app/Repository/SchoolYearRepository.php
     *
     */
    public function compose(View $view): void
    {
        //request()->route()->getName()
        if(isset($_SESSION['school_year_use'])){
            $schoolYearSelectedPrincipalComposer=$_SESSION['school_year_use'];
        }else{
            $current=$this->schoolYearInterface->getActiveCurrent();
            if(isset($current->serial_scy) && $current->serial_scy>0){
                $schoolYearSelectedPrincipalComposer=$current->serial_scy;
                $_SESSION['school_year_use']=$schoolYearSelectedPrincipalComposer;
            }else{
                $schoolYearSelectedPrincipalComposer=0;
            }
        }
        $schoolYears=$this->readOnlyInterface->getAllActive();
        $view->with('schoolYearsComposer', $schoolYears)
             ->with('schoolYearSelectedPrincipalComposer', $schoolYearSelectedPrincipalComposer);
    }
}
