<?php

namespace App\Http\ViewComposers;
use App\Contracts\MenuServiceInterface;
use App\Repository\ProcessRepository;
use Illuminate\View\View;

class MenuComposer
{
    protected  $menuService;
    //MenuServiceInterface
    //ProcessRepository

    /**
     * @author Diego Navarrete
     * @date 2023-12-25
     * @provider ServicesRutatecServiceProvider
     * @param MenuServiceInterface $menuService -> app/Service/MenuService.php
     * @return view
     */
    public function __construct(MenuServiceInterface $menuService)
    {
        $this->menuService=$menuService;
    }


    /**
     * Bind data to the view.
     */
    public function compose(View $view): void
    {
        $menu=$this->menuService->menu();
        $view->with('menu', $menu);
    }
}
