<?php

namespace App\Http\ViewComposers;
use App\Contracts\Repository\Flag\FlagDropdownProcessInterface;
use App\Contracts\SchoolYear\SchoolYearInterface;
use App\Contracts\Service\Flag\FlagDropdownProcessServiceInterface;
use Illuminate\View\View;

class FlagConfiguredPrincipalBarComposer
{

    /**
     * @author Diego Navarrete
     * @date 2023-11-19
     * @description constructor para instanciar interfaces de uso en la clase
     * @param FlagDropdownProcessServiceInterface $flagDropdownProcessServiceInterface --> app/Service/Flag/FlagDropdownConfiguredService.php
     *
     */
    public function __construct(FlagDropdownProcessServiceInterface $flagDropdownProcessServiceInterface)
    {
        $this->flagDropdownProcessServiceInterface=$flagDropdownProcessServiceInterface;
    }


    /**
     * @author Diego Navarrete
     * @date 2023-11-19
     * @description armar los datos para pasarlo a la vista resources/views/layout/dropdownPrincipalBarControl.blade.php
     * @param FlagDropdownProcessServiceInterface $flagDropdownProcessServiceInterface --> app/Service/Flag/FlagDropdownConfiguredService.php
     *
     */
    public function compose(View $view): void
    {

        //TODO:DIEGO revisar si se cambia el path de busqueda de la ruta
        $currentRoute=request()->route()->getName();
        //reviso todas las banderas configuradas para el proceso actual
        $flagsConfigured=$this->flagDropdownProcessServiceInterface->flagsDropdownProcess('laravel/public'.$currentRoute,'ALL');
        //reviso si la bandera de año lectivo esta configurada
        $flagsSchoolYearConfigured=$this->flagDropdownProcessServiceInterface->flagsDropdownProcess('laravel/public'.$currentRoute,'SCHOOL_YEAR');

        $view->with('flagsConfiguredComposer', $flagsConfigured)
             ->with('flagsSchoolYearConfiguredComposer', $flagsSchoolYearConfigured);
    }
}
