<?php

namespace App\Http\Middleware;

use App\Contracts\SessionsBetweenVersions\SessionsBetweenVersionsInterface;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Symfony\Component\HttpFoundation\Response;

class ValidateLifeToken
{
    public function __construct(SessionsBetweenVersionsInterface $sessionsBetweenVersionsInterface)
    {
        $this->sessionsBetweenVersionsInterface=$sessionsBetweenVersionsInterface;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if($request->session()->has('life_token') && $request->session()->has('current_serial_usr')){
            $serialUsr=$request->session()->get('current_serial_usr');
            $lifeTokenCurrent=$request->session()->has('life_token');
            $lifeTokenExist=$this->sessionsBetweenVersionsInterface->getLifeToken($serialUsr,$lifeTokenCurrent);
            if($lifeTokenExist && $lifeTokenExist->date_create_life_token_sbv){
                $this->sessionsBetweenVersionsInterface->updateLifeToken();
            }
        }else{
            return redirect(Config::get("constants.key_encrypt_methods").'/main');
        }
        return $next($request);
    }
}
